<?php
/*!
 * FormMailer
 * https://krinya.de
 * Version 1.0
 * Copyright 2021, Riyuri. Alle Rechte vorbehalten.
 * - zum einfachen Erstellen von Formularen, die eine E-Mail senden -
*/

class Formular {
    protected $yourmail = "mail@mail.de"; //Diese Mail durch deine eigene austauschen
    public $betreffpre = "Hexenschule: "; //Dieser Text wird vor jedem Betreff angezeigt, wenn du setBetreff verwendet hast
    public $betreffdefault = "Hexenschule"; //Dieser Text wird angezeigt, wenn sonst kein Betreff angegeben wurde
    public $sent = "Die Nachricht wurde erfolgreich verschickt."; //Die Nachricht wird angezeigt, wenn das Formular erfolgreich abgeschickt wurde
    public $idname = "Schülernummer"; //Wie lautet die Beschriftung von createFeldID?
    
    /* Ab hier nichts mehr bearbeiten! */
    
    public $betreff = "";
    public $adminfehler = ""; //Prüft ob das Formular korrekt erstellt wurde
    public $form = "";
    public $post;
    public $nichtanzeigen = 0;
    public $beschriftung = array(); //Beschriftung in der Mail
    public $duplicate = array(); //Zur Prüfung ob Namen doppelt vergeben wurden
    public $usesendform = 0; //Zur Prüfung ob Namen doppelt vergeben wurden
    public $required = array();
    
    function __construct () {
        if ($_SERVER['REQUEST_METHOD']=="POST") {
        foreach ($_POST as $key => $value) {
                $this->post[$key] = $this->xss($value);
            }
        }
    }
    
    public function xss($text) {
        $return = trim($text);
        $return = strip_tags($return);
        $return = stripslashes($return);
        $return = htmlspecialchars($return, ENT_QUOTES, 'UTF-8');
        return $return;
    }

    private function kurzform ($string) {
        //$string = preg_replace('/\PL/u', '', strtolower(trim($string)));
        $string = strtolower(trim($string));
        $string = str_replace("-", "", $string);
        $string = str_replace(" ", "", $string);
        return $string;
    }
    
    protected function isRequired ($required, $kurz = "") {
        $array = array("ja", "required", "an", 1, "1", "pflicht", "Pflicht", "muss", "zwang", "Pflichtfeld", "pflichtfeld");
        if (in_array($required, $array)) {
            $this->required[] = $kurz;
            return "required";
        } else {
            return "";
        }
    }
    
    public function setBetreff ($betreff) {
        $this->betreff = $betreff;
    }
    
    public function createFeldName ($required = 1) {
        $kurz = "name";
        $required = $this->isRequired($required, $kurz);
        $form = "<tr>";
        $form .= "<td><label for='name'>Name</label>";
        if (!empty($required)) {
            $form .= " *";
        }
        $form .= "</td>";
        $form .= "<td><input type='text' name='name'";
        if (!empty($this->post[$kurz])) {
            $form .= " value='".$this->post[$kurz]."'";
        }
        $form .= " ".$required."></td>";
        $form .= "</tr>";
        $this->form .= $form;
        $this->beschriftung["name"] = "Name";
        $this->duplicate[] = "name";
    }
    
    public function createFeldID ($required = 1) {
        $kurz = "id";
        if (!empty($this->idname)) {
            $name = $this->idname;
        } else {
            $name = "ID";
        }
        $required = $this->isRequired($required, $kurz);
        $form = "<tr>";
        $form .= "<td><label for='id'>".$name."</label>";
        if (!empty($required)) {
            $form .= " *";
        }
        $form .= "</td>";
        $form .= "<td><input type='text' name='id' ";
        if (!empty($this->post[$kurz])) {
            $form .= "value='".$this->post[$kurz]."' ";
        }
        $form .= $required."></td>";
        $form .= "</tr>";
        $this->form .= $form;
        $this->beschriftung["id"] = $name;
        $this->duplicate[] = "id";
    }
    public function createFeldMail ($required = 1) {
        $kurz = "email";
        $required = $this->isRequired($required, $kurz);
        $form = "<tr>";
        $form .= "<td><label for='email'>E-Mail</label>";
        if (!empty($required)) {
            $form .= " *";
        }
        $form .= "</td>";
        $form .= "<td><input type='mail' name='email' ";
        if (!empty($this->post['email'])) {
            $form .= "value='".$this->post['email']."' ";
        }
        $form .= $required."></td>";
        $form .= "</tr>";
        $this->form .= $form;
        $this->beschriftung["email"] = "E-Mail-Adresse";
        $this->duplicate[] = "email";
    }
    
    public function createFeld ($name=null, $required = 1, $art = "text") {
        $kurz = $this->kurzform($name);
        $required = $this->isRequired($required, $kurz);
        $arten = array("number", "mail", "text");
        if (!in_array($art, $arten)) { $art = "text"; }
        $form = "<tr>";
        $form .= "<td><label for='".$kurz."'>".$name."</label>";
        if (!empty($required)) {
            $form .= " *";
        }
        $form .= "</td>";
        $form .= "<td><input type='".$art."' name='".$kurz."'";
        if (!empty($this->post[$kurz])) {
            $form .= " value='".$this->post[$kurz]."'";
        }
        $form .= " ".$required."></td>";
        $form .= "</tr>";
        $this->form .= $form;
        if (empty($name)) { $this->adminfehler .= "Name von Textzeile fehlt! "; }
        $this->beschriftung[$kurz] = $name;
        $this->duplicate[] = $kurz;
    }
    
    public function createSelect ($name=null, $options = array(), $required = 1) {
        $kurz = $this->kurzform($name);
        $required = $this->isRequired($required, $kurz);
        
        $form = "<tr>";
        $form .= "<td><label for='".$kurz."'>".$name."</label>";
        if (!empty($required)) {
            $form .= " *";
        }
        $form .= "</td>";
        $form .= "<td><select name='".$kurz."' ".$required.">";
            $form .= "<option value=''>-- Bitte wählen --</option>";
        foreach ($options as $option) {
            $form .= "<option";
            if (!empty($this->post[$kurz]) && $this->post[$kurz] == $option) {
                $form .= " selected";
            }
            $form .= ">".$option."</option>";
        }
        $form .= "</select>";
        $form .= "</td>";
        $form .= "</tr>";
        $this->form .= $form;
        if (empty($name)) { $this->adminfehler .= "Name von Select fehlt! "; }
        $this->beschriftung[$kurz] = $name;
        $this->duplicate[] = $kurz;
    }
    
    
    public function createRadio ($name=null, $options = array(), $required = 1) {
        $kurz = $this->kurzform($name);
        $required = $this->isRequired($required, $kurz);
        
        $form = "<tr>";
        $form .= "<td>".$name;
        if (!empty($required)) {
            $form .= " *";
        }
        $form .= "</td>";
        $form .= "<td>";
        foreach ($options as $option) {
            $form .= "<label><input type='radio' name='".$kurz."' value='".$option."'";
            if (!empty($this->post[$kurz]) && $this->post[$kurz] == $option) {
                $form .= " checked";
            }
            $form .= "> ".$option."</label><br>";
        }
        $form .= "</td>";
        $form .= "</tr>";
        $this->form .= $form;
        if (empty($name)) { $this->adminfehler .= "Name von Radio Buttons fehlt! "; }
        $this->beschriftung[$kurz] = $name;
        $this->duplicate[] = $kurz;
    }
    
    public function createCheckbox ($name=null, $options = array(), $required = 1) {
        $kurz = $this->kurzform($name);
        $required = $this->isRequired($required, $kurz);
        
        $form = "<tr>";
        $form .= "<td>".$name;
        if (!empty($required)) {
            $form .= " *";
        }
        $form .= "</td>";
        $form .= "<td>";
        foreach ($options as $option) {
            $form .= "<label><input type='checkbox' name='".$kurz."' value='".$option."'";
            if (!empty($this->post[$kurz]) && $this->post[$kurz] == $option) {
                $form .= " checked";
            }
            $form .= "> ".$option."</label><br>";
        }
        $form .= "</td>";
        $form .= "</tr>";
        $this->form .= $form;
        if (empty($name)) { $this->adminfehler .= "Name von Checkbox fehlt! "; }
        $this->beschriftung[$kurz] = $name;
        $this->duplicate[] = $kurz;
    }
    
    public function createTextfeld ($name=null, $required=1, $platzhalter="") {
        $kurz = $this->kurzform($name);
        $required = $this->isRequired($required, $kurz);
        $form = "<tr>";
        $form .= "<td><label for='".$kurz."'>".$name."</label>";
        if (!empty($required)) {
            $form .= " *";
        }
        $form .= "</td>";
        $form .= "<td><textarea name='".$kurz."' placeholder='".$platzhalter."'></textarea></td>";
        $form .= "</tr>";
        $this->form .= $form;
        if (empty($name)) { $this->adminfehler .= "Name von Textfeld fehlt! "; }
        $this->beschriftung[$kurz] = $name;
        $this->duplicate[] = $kurz;
    }
    
    private function handleForm () {
        if ($_SERVER['REQUEST_METHOD']=="POST") {
            $fehler = 0;
            $mitteilung = "";
            foreach ($this->post as $key => $value) {
                $mitteilung .= $this->beschriftung[$key].": ".$value."\r\n";
            }
            
            foreach ($this->required as $key => $value) {
                if (empty($this->post[$key])) {
                    $fehler = 1;
                    $this->sent = "Bitte füll alle Pflichtfelder aus.";
                }
            }
            
            if (empty($fehler)) {

            $get_info = "?status=success";
            $uri = explode('?', $_SERVER['REQUEST_URI'], 2);
            $uri = $uri[0];
            $headers   = array();
            $headers[] = "MIME-Version: 1.0";
            $headers[] = "Content-type: text/plain; charset=utf-8";
            
            if (!empty($this->post['mail']) && !empty($this->post['name'])) {
                $headers[] = "From: ".$this->post['name']." <".$this->post['mail'].">";
            } elseif (!empty($this->post['mail']) OR !empty($this->post['name'])) {
                if (!empty($this->post['mail'])) {
                    $absender = "<".$this->post['mail'].">";
                } else {
                    $absender = $this->post['name'];
                }
                $headers[] = "From: ".$absender;
            } else {
                $headers[] = "From: unbekannt";
            }
            $headers[] = "Reply-To: ".$this->yourmail;
            
            if (!empty($this->betreff)) {
                $betreff = $this->betreffpre.$this->betreff;
            } else {
                $betreff = $this->betreffdefault;
            }
            if (empty($betreff)) {
                $betreff = "kein Betreff";
            }
            
            
            
            //Verschicken
            if (mail($this->yourmail, $betreff, $mitteilung, implode("\r\n",$headers))) {
                if (!headers_sent()) {
                    header("Location: ".$uri.$get_info,303);
                    exit();
                } else {
                    echo $this->sent;
                    $this->nichtanzeigen = 1;
                }
            } else {
                $this->sent = "Es gab einen Fehler beim Versenden. Bitte versuch es nochmal oder schreib eine E-Mail an ".$this->yourmail.".";
            }
            }
        }
    }
    
    public function sendForm () {
        $this->usesendform = 1;
        $uniq = array_unique($this->duplicate); //Entfernt die Duplikate aus dem Beschriftungs-Array
        if (count($uniq) != count($this->duplicate)) { //Wenn etwas entfernt wurde (also es doppelte gibt) ist die Anzahl ungleich vorher
            $this->adminfehler .= " Es gibt doppelte Beschriftungen.";
        }
        if (!empty($this->adminfehler)) {
                echo $this->adminfehler;
        } else {
                $this->handleForm();
        }
    }
    
    public function showForm () {
        if (empty($this->usesendform)) {
            $this->sendForm();
        }
        
        if (isset($_GET['status']) && $_GET['status'] == "success") {
            echo $this->sent;
            $this->nichtanzeigen = 1;
        } elseif ($_SERVER['REQUEST_METHOD'] == "POST") {
            echo $this->sent;
        }
        
        if (empty($this->nichtanzeigen)) {
            echo "<form method='POST'>";
            echo "<table style='width: 100%;'>";
            echo $this->form;
            echo "<tr><td colspan=2><input type='submit' value='Abschicken'></td></tr>";
            echo "</table>";
            echo "</form>";
            echo "<i>Alle mit * markierten Felder müssen ausgefüllt werden.</i>";
        }
    }
    
}